/********************************************************************
 FileName:		init.c
********************************************************************/

/** INCLUDES *******************************************************/
#include "delays.h"

#include "include/Compiler.h"
#include "include/GenericTypeDefs.h"
#include "HardwareProfile.h"

#include "ax12.h"
#include "init.h"

/** D E F I N E S ************************************************************/

/** V A R I A B L E S ********************************************************/
#pragma udata
char 	movingSpeedhight[3] = { 0x20, 0xFF, 0x03 };
char 	movingSpeedmed[3] = { 0x20, 0xFF, 0x01 };
char 	maxTorque[3] = { 0x22, 0xFF, 0x03 };
char	noresponse[2] = { 0x10, 0x01 };

/** D E C L A R A T I O N S **************************************************/
#pragma code

// ***********************************
// Initialisation de la comunication avec le servomoteur
// ***********************************
void init_AX12(void)
{
	mInitSENSE_AX12();		// sens inititialis
	mInitAX12();			// port AX12 initialis
	AX_SetupUSART();		// communication AX12 initialis
// vitesse du servomoteur au max
	AX_TxPacket(0x01, I_WRITE_DATA, movingSpeedhight, 3);
	Delay100TCYx(12);
// couple du servomoteur au max
	AX_TxPacket(0x01, I_WRITE_DATA, maxTorque, 3);
	Delay100TCYx(12);
// pas de reponse du servomoteur sauf lors de la commande lecture
	AX_TxPacket(0x01, I_WRITE_DATA, noresponse, 2);
	Delay100TCYx(12);
}

// ***********************************
// Initialisation des interuptions et des Timers
// ***********************************
void init_interupt(void)
{
	RCONbits.IPEN = 1;			// valide les interuptions prioritaire
	INTCONbits.GIEH = 1;		// valide les interuption haute priorit
	INTCONbits.GIEL = 1;		// valide les interuption basse priorit
	// interuption INT0
	INTCON2bits.INTEDG0 = 1;	// interuption sur front montant de INT0
	INTCONbits.INT0IE = 1;		// Valide interuption sur INT0
	// interuption INT2
	INTCON2bits.INTEDG2 = 1;	// interuption sur front montant de INT2
	INTCON3bits.INT2IP = 1;		// INT2 priorit haute
	INTCON3bits.INT2IE = 1;		// Valide interuption sur INT2
	
	// init du TIMER0
// periode la plus courte du capteur a 8000RPM => 7,5ms
// periode du Timer en mode 16bit, prescaleur a 1:1 => 5,46ms
	T0CONbits.T08BIT = 0;		// mode 16bits
	T0CONbits.TMR0ON = 1;		// Timer0 lanc
	T0CONbits.PSA = 1;			// prescaleur a 1:1
	T0CONbits.T0CS = 0;			// source du timer0 sur Fosc/4
	// interuption sur TIMER0
	INTCONbits.TMR0IE = 1;		// valide l'interuption du Timer0
	INTCON2bits.TMR0IP = 0;		// Timer0 priorit basse pour eviter de flouer les RPM

	// init du TIMER1
	T1CONbits.RD16 = 0;		// mode R/W 16bits
	T1CONbits.T1RUN = 0;	// autre source d'oscilateur
	T1CONbits.T1CKPS0 = 0;	// prescaleur a 1:1
	T1CONbits.T1CKPS1 = 0;
	T1CONbits.T1OSCEN = 0;	// Timer1 oscilator off
	T1CONbits.TMR1CS = 0;	// source du timer1 sur Fosc/4
	// interuption sur TIMER1
	PIE1bits.TMR1IE = 1;	// valide interuption Timer1 
	IPR1bits.TMR1IP = 1;	// Timer1 haute priorit

	// init du TIMER3
	T3CONbits.RD16 = 0;		// mode R/W 16bits
	T3CONbits.T3CKPS0 = 1;	// prescaleur a 1:8
	T3CONbits.T3CKPS1 = 1;
	T3CONbits.TMR3CS = 0;	// source du timer3 sur Fosc/4
	// interuption sur TIMER3
	IPR2bits.TMR3IP = 0;	// Timer1 basse priorit
}

/** EOF interuption.c ***************************************************************/
